use master
GO

set nocount on 

declare @ProjectPayload01 nvarchar(max) = N'
-- DEV-82148  script 2422
IF NOT EXISTS (
	SELECT 1
	FROM [Installation]
	WHERE [INSSECTION] = ''OPTIONS'' AND [INSIDENT] = ''DisableNextNavigationOnBrowse''
)
BEGIN
	INSERT INTO [Installation] ([INSSECTION], [INSIDENT], [INSVALUE], [projectId], [modifiedBy], [modified])
	VALUES (''OPTIONS'', ''DisableNextNavigationOnBrowse'', N''1'', 0, 0, GETUTCDATE());
END
'

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)

declare @TotalProjectsDB int,
        @ThisProjectsDB nvarchar(128),
		@ProjectsDBCounter int = 0, 
		@ProjectsDBCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

		
insert into #DB 
SELECT [name] AS DBName, 0 AS Processed FROM sys.databases WHERE [name] like 'VOXCO_Project_%';
	     
select @TotalProjectsDB = count(*) 
	    from #DB
	
set @ProjectsDBCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
open @ProjectsDBCursor
fetch next from @ProjectsDBCursor into @ThisProjectsDB
while @@FETCH_STATUS = 0 begin
	select @ProjectsDBCounter += 1
	select @DBSQL = @ThisProjectsDB + N'.sys.sp_executesql'
	select @StatusMessage = 'Updating Project database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @ProjectsDBCounter / @TotalProjectsDB
	raiserror (@StatusMessage, 0, 1, @ThisProjectsDB, @ProjectsDBCounter, @TotalProjectsDB, @StatusPercent) with nowait
	
	SELECT 'Updating Project DB: ' + @ThisProjectsDB
        print 'Project Payload 1'
        if isnull(@ProjectPayload01, '') <> '' exec @DBSQL @ProjectPayload01

	print 'All Project Payload done!'

	update #DB set Processed = 1 where current of @ProjectsDBCursor
	fetch next from @ProjectsDBCursor into @ThisProjectsDB
end

close @ProjectsDBCursor
deallocate @ProjectsDBCursor

--select * from #DB

drop table #DB

